import pattern.en
from pattern.graph import Graph
import logging
import os

import sqlite3 as sql

logging.root.setLevel(logging.INFO)
g = Graph()
connection = sql.connect('../emma.db')
cursor = connection.cursor()

logging.info("Checking for association model")
if not os.path.isfile('../emma.db'):
    logging.critical("Association model not found! Run emma.py to generate a blank one.")
    quit

logging.info("Loading association model")
with connection:
    cursor.execute('SELECT * FROM associationmodel;')
    associationModel = []
    for row in cursor.fetchall():
        associationModel.append(row)

logging.info("Building graph")
minWeight = input("Minimum weight (0-1): ")
for word, association, target, weight in associationModel:
    if weight > minWeight:
        g.add_node(word)
        g.add_node(target)

        # Choose the color of line to draw
        stroke = ()
        if association == "IS-A":
            g.add_edge(word, target, stroke=(1.0, 0.0, 0.0, weight))
        if association == "HAS":
            g.add_edge(word, target, stroke=(0.0, 1.0, 0.0, weight))
        if association == "HAS-ABILITY-TO":
            g.add_edge(word, target, stroke=(0.0, 0.0, 1.0, weight))
        if association == "HAS-PROPERTY":
            g.add_edge(word, target, stroke=(1.0, 0.0, 1.0, weight))


logging.info("Exporting graph")
g.export('emma', directed=True, width=1200, height=900, ipf=5)